function [status,BSL,BSR,dt_array,mean_I_array,level_pts]=Level_Splitting_Light(data,time_data,stdI0,over_clusters)

[~,pos_down]=findpeaks(-data,'MinPeakProminence',stdI0);
[~,pos_upward]=findpeaks(data,'MinPeakProminence',stdI0);
pos=[pos_down;pos_upward];
data_peaks=data(pos);
peak_array=[pos data_peaks];

if isempty(peak_array)==0
    idx_DBS = dbscan(peak_array,stdI0,1);
    clusters=length(unique(idx_DBS));
else
    clusters=2;
end

fcpts_prel=sort(findchangepts(data,'MaxNumChanges',clusters+over_clusters));%sorting and taking only the unqiue ones
%fcpts_prel=sort(findchangepts(data,'MinThreshold',stdI0));

if length(fcpts_prel)<2
    fcpts_prel=sort(findchangepts(data,'MaxNumChanges',2));
end
%tuning fcpts
fcpts=fcpts_prel;

for i=1:length(fcpts_prel)-1
    start_fc=fcpts_prel(i);
    end_fc=fcpts_prel(i+1);
        
    while (data(start_fc-1)>=data(start_fc) && start_fc>fcpts_prel(1))
          start_fc=start_fc-1;
     end
    fcpts(i)=start_fc;
    
    while data(end_fc)>data(end_fc-1) && end_fc<fcpts_prel(end)-2
          end_fc=end_fc+1;
    end
    fcpts(i+1)=end_fc;
    
end

fcpts=unique(sort(fcpts));

%sizing and saving
fcpts_size=size(fcpts,1);

if fcpts_size>=2
   
   mean_I_array=zeros(fcpts_size-1,1);
   dt_array=zeros(fcpts_size-1,1);
   level_pts=zeros(fcpts_size,1);
   level_pts(1)=fcpts(1);
   
   % left baseline
   BSL=mean(data(1:fcpts(1)));
   
   for i=1:fcpts_size-1
       
       t_data=time_data(fcpts(i)+1:fcpts(i+1));
       I_array=data(fcpts(i)+1:fcpts(i+1));
       sub_event_size=size(t_data,1);
       
       [~,~,lvl_data] = Level_STD_Comp(I_array,sub_event_size);
       weighted_mean_I=weighted_mean(lvl_data);
       %weighted_mean_I=weighted_mean(I_array);
       
       mean_event_data=[t_data repmat(weighted_mean_I,sub_event_size,1)];
       level_pts(i+1)=fcpts(i+1);
       dt_array(i)=sub_event_size;
       mean_I_array(i)=weighted_mean_I;
       
   end
   
   % right baseline
   level_pts=sort(unique([level_pts;fcpts(end)]));
   BSR=mean(data(fcpts(end)+1:end));

   if size(dt_array,2)==0%indicative of an empty array
       status=0; %no event data left in the array
   else
       status=1;% events!
   end
   
else
   status=0;
   dt_array=0;
   mean_I_array=0;
   level_pts=0;
   BSL=0;
   BSR=0;
end

end